within Simulator;

package UsersGuide "User's Guide"
  extends Modelica.Icons.Information;






 
  annotation(
    Documentation(info = "<html><head></head><body><p style=\"font-size: 12px;\"><strong>Simulator</strong>&nbsp;is a&nbsp;<b>chemical process library</b>&nbsp;package that is developed with the Modelica language from FOSSEE, IIT Bombay. It is also called&nbsp;<b>OpenModelica Chemical Simulator (OMChemSim)</b>. It provides chemical component databases, thermodynamic packages and functions, models for units operations.</p><p style=\"font-size: 12px;\">This is a short&nbsp;<strong>User's Guide</strong>&nbsp;for the overall library. Some of the main sublibraries have their own documentations that can be accessed by the following links:</p><p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"2\"><caption align=\"bottom\"><br></caption><caption align=\"bottom\"><br></caption><tbody>
<tr><td><a href=\"modelica://Simulator.Files.ChemsepDatabase\">ChemsepDatabase</a></td><td>Library of components along with their thermophysical properties&nbsp;</td></tr>
<tr><td><a href=\"modelica://Simulator.Files.ThermodynamicPackages\">ThermodynamicPackages</a></td><td>Library of different thermodynamic packages</td></tr>
<tr><td><a href=\"modelica://Simulator.Files.ThermodynamicFunctions\">ThermodynamicFunctions</a></td><td> </td></tr>
<tr><td><a href=\"modelica://Simulator.Streams\">Streams</a></td><td>Models of material stream and energy stream representing the mass and energy flow in the unit operations </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations\">UnitOperations</a></td><td>Models of different chemical process unit operations</td></tr>
<tr><td><a href=\"modelica://Simulator.Examples\">Examples</a></td><td>Library of examples demonstrating how to use the Chemsep Database, Thermodynamic Packages, Streams and Unit Operations together to perform chemical process simulation</td></tr>
</tbody></table><p></p></body></html>"));
end UsersGuide;
