within Simulator;
package UnitOperations
  extends Modelica.Icons.VariantsPackage;

  annotation(
    Documentation(info = "<html><head></head><body><p style=\"font-size: 12px;\"><strong>UnitOperations</strong>&nbsp;package is a library of chemical process models that is used to signify any physical change or chemical transformation in a chemical process industry.</p><p style=\"font-size: 12px;\">This is a short&nbsp;<strong>Documentation</strong>&nbsp;for the UnitOperations library. All the models inside this library have their own documentations that can be accessed by the following links:</p><p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"2\"><caption align=\"bottom\"><br></caption><caption align=\"bottom\"><br></caption><tbody>
<tr><td><a href=\"modelica://Simulator.UnitOperations.Mixer\">Mixer</a></td><td><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 13px; orphans: 2; widows: 2;\">Model of a <b>Mixer</b>&nbsp;used to mix up to any number of material streams into one, while executing all the mass and energy balances</span></td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.Heater\">Heater</a></td><td><span style=\"font-size: 12px;\">Model of a </span><b style=\"font-size: 12px;\">Heater</b><span style=\"font-size: 12px;\">&nbsp;used to simulate the heating process of a material stream</span></td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.HeatExchanger\">HeatExchanger</a></td><td>Model of a <b>Heat Exchanger</b> for simultaneous heating and cooling of material streams through heat exchange</td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.Cooler\">Cooler</a></td><td><span style=\"font-size: 12px;\">Model of a&nbsp;</span><b style=\"font-size: 12px;\">Cooler</b><span style=\"font-size: 12px;\">&nbsp;used to simulate the cooling process of a material stream</span> </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.Valve\">Valve</a></td><td>Model of a <b>Valve</b> to regulate the pressure of a material stream</td></tr><tr><td><a href=\"modelica://Simulator.UnitOperations.ShortcutColumn\">ShortcutColumn</a></td><td><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 13.3333px; orphans: 2; widows: 2;\">Model of a <b>Shortcut Column</b>&nbsp;used in calculation of minimum reflux in a distillation column by Fenske-Underwood-Gilliland (FUG) method<br></span></td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.CompoundSeparator\">CompoundSeparator</a></td><td>Model of a <b>Compound Separator</b> <span style=\"font-size: 12px;\">used to simulate the separation process of a material stream bases on mass balance</span></td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.Flash\">FlashColumn</a></td><td>Model of a <b>Flash Column</b> to separate vapor and liquid phases from a mixed phase material stream </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.Splitter\">Splitter</a></td><td><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 13px; orphans: 2; widows: 2;\">Model of a&nbsp;</span><b style=\"font-family: Arial, Helvetica, sans-serif; font-size: 13px; orphans: 2; widows: 2;\">Splitter</b><span style=\"font-family: Arial, Helvetica, sans-serif; font-size: 13px; orphans: 2; widows: 2;\">&nbsp;used to split up one material stream into three, while executing all the mass and energy balances</span> </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.CentrifugalPump\">CentrifugalPump</a></td><td>Model of a <b>Centrifugal Pump</b> to provide energy to liquid stream in form of pressure </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.AdiabaticCompressor\">AdiabaticCompressor</a></td><td><span style=\"font-weight: normal;\">Model of an </span><b>Adiabatic Compressor</b><span style=\"font-weight: normal;\"> to provide energy to vapor stream in form of pressure </span></td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.AdiabaticExpander\">AdiabaticExpander</a></td><td>Model of an <b>Adiabatic Expander</b> to extract energy from a vapor stream in form of pressure </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.ConversionReactor\">ConversionReactor</a></td><td>Model of a <b>Conversion Reactor</b> to calculate the outlet stream mole fraction of components while specifying the component conversion</td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.EquilibriumReactorReactor\">EquilibriumReactor</a></td><td>Model of an&nbsp;<b>Equilibrium Reactor</b> to calculate the outlet stream mole fraction of components while specifying the component conversion</td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.PFR\">PFR</a></td><td>Model of a <b>Plug Flow Reactor</b> to calculate the outlet stream mole fraction of components while describing chemical reactions in continuous, flowing systems of cylindrical geometry </td></tr><tr><td><a href=\"modelica://Simulator.UnitOperations.CSTR\">CSTR</a></td><td>Model of a <b>Continuous Stirred Tank Reactor</b> to&nbsp;calculate the outlet stream mole fraction of components while describing chemical reactions in continuous, flowing systems of cylindrical geometry</td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.DistillationColumn\">DistillationColumn</a></td><td>Model of a <b>Distillation Column</b> representing fractionating towers where mixture is separated in equilibrium stages </td></tr>
<tr><td><a href=\"modelica://Simulator.UnitOperations.AbsorptionColumn\">AbsorptionColumn</a></td><td>Model of an&nbsp;<b>Absorption Column</b>&nbsp;representing fractionating towers where mixture is separated in equilibrium stages </td></tr>
</tbody></table><p></p></body></html>"));
end UnitOperations;
