within Simulator.Files.Thermodynamic_Functions;

function BIP_UNIQUAC
  input Integer NOC;
  input String Comp[NOC];
  output Real value[NOC, NOC];
  constant String underscore = "_";
  String c[NOC, NOC];
  String d[NOC, NOC];
  constant String Comp1_Comp2[440] = {"Butane_Methanol", "Pentane_Ethanol", "Twomethylbutane_Ethanol", "Hexane_Ethanol", "Hexane_Onepropanol", "Cyclohexane_Onepropanol", "Methylcyclohexane_Phenol", "Isobutylene_Methanol", "Twomethyltwobutene_Methanol", "Twomethyltwobutene_Ethanol", "Onehexene_Methanol", "Onehexene_Ethanol", "Onethreebutadiene_Methanol", "Onethreepentadiene_Methanol", "Transonethreepentadiene_Methanol", "Isoprene_Methanol", "Isoprene_Ethanol", "Cyclopentadiene_Methanol", "Benzene_Chloroform", "Benzene_Phenol", "Benzene_Toluene", "Benzene_Pxylene", "Benzene_Onepropanol", "Toluene_Chloroform", "Toluene_Pxylene", "Acetaldehyde_Water", "Propionicaldehyde_Water", "Propionicaldehyde_Methanol", "Isobutyraldehyde_Water", "Acetone_Chloroform", "Acetone_Benzene", "Acetone_Phenol", "Acetone_Cyclohexane", "Acetone_Toluene", "Acetone_Ethanol", "Twobutanone_Benzene", "Twobutanone_Cyclohexane", "Twobutanone_Toluene", "Twobutanone_Nheptane", "Twobutanone_Water", "Twobutanone_Onepropanol", "Methanol_Water", "Methanol_Chloroform", "Methanol_Ethanol", "Methanol_Acetone", "Methanol_Benzene", "Methanol_Cyclohexane", "Methanol_Toluene", "Methanol_Nheptane", "Methanol_Tetrachloromethane", "Methanol_Tribromomethane", "Methanol_Acetonitrile", "Methanol_Onetwodichloroethane", "Methanol_Aceticacid", "Methanol_Dimethylsulfoxide", "Methanol_Propionicacid", "Methanol_Nndimethylformamide", "Methanol_Propanol", "Methanol_Thiophene", "Methanol_Methylacrylate", "Methanol_Twobutanone", "Methanol_Tetrahyrofuran", "Methanol_Onefourdioxane", "Methanol_Ethylacetate", "Methanol_Sulfolane", "Methanol_Onebutanol", "Methanol_Twobutanol", "Methanol_Tertbutanol", "Methanol_Onefourbutanediol", "Methanol_Pyridine", "Methanol_Methylmethacrylate", "Methanol_Methylisopropylketone", "Methanol_Threepentanone", "Methanol_Piperidine", "Methanol_Hexafluorobenzene", "Methanol_Chlorobenzene", "Methanol_Aniline", "Methanol_Twomethylpyridine", "Methanol_Threemethylpyridine", "Methanol_Fourmethylpyridine", "Methanol_Cyclohexene", "Methanol_Nbutylacetate", "Methanol_Hexane", "Methanol_Triethylamine", "Methanol_Twomethylphenol", "Methanol_Two6dimethylpyridine", "Methanol_Oneheptane", "Methanol_Methylcyclohexane", "Methanol_Heptane", "Methanol_Ethylbenzene", "Methanol_Mxylene", "Methanol_Pxylene", "Methanol_Oneoctene", "Methanol_Octane", "Methanol_Twotwofourtrimethylpentane", "Methanol_Onedodecanol", "Methanol_Oleic acid", "Ethanol_Water", "Ethanol_Chloroform", "Ethanol_Acetone", "Ethanol_Twobutanone", "Ethanol_Benzene", "Ethanol_Cyclohexane", "Ethanol_Toluene", "Ethanol_Nheptane", "Ethanol_Pxylene", "Ethanol_Tetrachloroethylene", "Ethanol_Acetonitrile", "Ethanol_Onetwodichloroethane", "Ethanol_Acetic acid", "Ethanol_Onetwoethanediol", "Ethanol_Twopropanol", "Ethanol_Onetwopropanediol", "Ethanol_Thiophene", "Ethanol_Onefourdioxane", "Ethanol_Sulfolane", "Ethanol_Morpholine", "Ethanol_Twobutanol", "Ethanol_Twomethylonepropanol", "Ethanol_Pyridine", "Ethanol_Methylmethacrylate", "Ethanol_Methylisopropyl", "Ethanol_Propylacetate", "Ethanol_Threemethylonebutanol", "Ethanol_Bromobenzene", "Ethanol_Chlorobezene", "Ethanol_Aniline", "Ethanol_Twomethylpyridine", "Ethanol_Threemethylpyridine", "Ethanol_Cyclohexanol", "Ethanol_Butylacetate", "Ethanol_Dipropylether", "Ethanol_Triethylamine", "Ethanol_Anisole", "Ethanol_Two6dimethylpyridine", "Ethanol_Pentylacetate", "Ethanol_Heptane", "Ethanol_Ethylbezene", "Ethanol_Octane", "Ethanol_Twotwofourtrimethylpentane", "Ethanol_Hexadecane", "Ethanol_Oleicacid", "Onepropanol_Water", "Onepropanol_Tetrachloroethylene", "Onepropanol_Aceticacid", "Onepropanol_Propionicacid", "Onepropanol_Twomethoxyethanol", "Propylamine_Onepropanol", "Onepropanol_Methacrylicacid", "Onepropanol_Twomethylonepropanol", "Onepropanol_Pyridine", "Onepropanol_Methylmethacrylate", "Onepropnaol_Propylacetate", "Onepropanol_Threemethylbutanol", "Onepropnaol_Chlorobenzene", "Onepropanol_Twomethylpyridine", "Onepropanol_Threemethylpyridine", "Onepropanol_Fourmethylpyridine", "Onepropanol_Propylpropionate", "Onepropanol_Dipropylamine", "Onepropanol_Hexamethyldisiloxane", "Onepropanol_Toluene", "Onepropnaol_Two6dimethylpyridine", "Onepropanol_Heptane", "Onepropanol_Pxylene", "Onepropanol_Octane", "Onepropanol_Decane", "Onepropanol_Onedecanol", "Twopropanol_Water", "Twopropanol_Onepropanol", "Isobutanol_Water", "Tertbutanol_Water", "Allylalcohol_Water", "Methylformate_Methanol", "Methylacetate_Water", "Methylacetate_Methanol", "Methylacetate_Ethanol", "Ethylacetate_Water", "Ethylacetate_Ethanol", "Vinylacetate_Ethanol", "Diethylether_Water", "Diethylether_Methanol", "Diethylether_Ethanol", "Diisopropylether_Water", "Methyltertbutylether_Methanol", "Dimethoxymethane_Water", "Dimethoxymethane_Methanol", "Ethyleneoxide_Water", "Propyleneoxide_Methanol", "Tetrahydrofuran_Water", "Tetrahydrofuran_Ethanol", "Tetrahydrofuran_Onepropanol", "Tetrachloromethane_Methanol", "Tertachloromethane_Onepropanol", "Vinylcloride_Methanol", "Dichloromethane_Methanol", "Dichloromethane_Ethanol", "Chloroform_Methanol", "Chloroform_Ethanol", "Onetwodichloroethane_Onepropanol", "Trichloroethylene_Onepropanol", "Threechloroonepropene_Water", "Butylchloride_Onepropanol", "Dimethylamine_Water", "Dimethylamine_Methanol", "Dimethylamine_Ethanol", "Dimethylamine_Onepropanol", "Ethylamine_Water", "Triethylamine_Water", "Triethylamine_Onepropanol", "Diethylamine_Water", "Diethylamine_Ethanol", "Propylamine_Water", "Nbutylamine_Water", "Butylamine_Ethanol", "Butylamine_Onepropanol", "Isopropylamine_Water", "Acetonitrile_Water", "Propionitrile_Water", "Acrylonitrile_Water", "Hexafluorobenzene_Onepropnaol", "Water_Acetone", "Water_Twobutanone", "Water_Phenol", "Water_Aceticacid", "Water_Nmethylformamide", "Water_Dimethylsulfoxide", "Water_Ethylenediamine", "Water_Acrylicacid", "Water_Propionicacid", "Water_Onethreefivetrioxane", "Water_Nndimethylformamide", "Water_Onefourdioxane", "Water_Sulfolane", "Water_Nndimethylacetamide", "Water_Morpholine", "Water_Nbutanol", "Water_Onefourbutanediol", "Water_Twothreebutanediol", "Water_Diethylenegylcol", "Water_Furfural", "Water_Pyridine", "Water_Nmethylpyrrolidone", "Water_Threemethylbutanol", "Water_Twomethyltwobutanol", "Water_Aniline", "Water_Twomethylpyridine", "Water_Threemethylpyridine", "Water_Fourmethylpyridine", "Water_Phenylhydrazine", "Water_Cyclohexanone", "Water_Mesityloxide", "Water_Cyclohexanol", "Water_Nbutylacetate", "Water_Diacetonealcohol", "Water_Onehexanol", "Water_Twohexanol", "Water_Twobutoxyethanol", "Water_Benzylalcohol", "Water_Two6dimethylpyridinr", "Water_Isopentylacetate", "Water_Acetophenone", "Water_Quinoline", "Water_Isopropylbenzene", "Halothane_Methanol", "Methanol_Formamide", "Methane_Acetone", "Methane_Propane", "Methane_Nbutane", "Methane_Npentane", "Methane_Benzene", "Methane_Nhexane", "Methane_Ndecane", "Ethane_Nheptane", "Ibutane_Nbutane", "Npentane_Acetone", "Nhexane_Nitroethane", "Nhexane_Aniline", "Nhexane_Methylcyclop", "Nhexane_Toluene", "Nheptane_Benzene", "Nheptane_Toluene", "Noctane_Nitroethane", "Noctane_Ipropanol", "Twotwofourtrimethylpentane_Nitroethane", "Twotwofourtrimethylpentane_Furfural", "Twotwofourtrimethylpentane_Benzene", "Twotwofourtrimethylpentane_Cyclohexane", "Twotwofourtrimethylpentane_Toluene", "Ndecane_Npropanol", "Ndecane_Nbutanol", "Ndecane_Ipropanol", "Cyclopentane_Benzene", "Methylcyclopentane_Benzene", "Methylcyclopentane_Toluene", "Cyclohexane_Nitromethan", "Cyclohexane_Npropanol", "Cyclohexane_Nbutanol", "Cyclohexane_Benzene", "Cyclohexane_Methylcyclop", "Cyclohexane_Nhexane", "Cyclohexane_Toluene", "Cyclohexane_Heptane", "Methylcyclohexane_Toluene", "Onebutene_Ibutane", "Onebutene_Propane", "Onebutene_Nbutane", "Benzene_Twobutanone", "Benzene_Nbutanol", "Benzene_Nhexane", "Benzene_Water", "Toluene_Furfural", "Hydrogen_Methanol", "Hydrogen_Acetone", "Hydrogen_Benzene", "Hydrogen_Nhexane", "Hydrogen_Mxylene", "Hydrogen_Noctane", "Hydrogen_Water", "Hydrogen_Ammonia", "Nitrogen_Nbutane", "Nitrogen_Nhexane", "Nitrogen_Water", "Nitrogen_Ammonia", "Carbonmonoxide_Methanol", "Carbonmonoxide_Acetone", "Carbonmonoxide_Benzene", "Carbonmonoxide_Noctane", "Acetaldehyde_Aceticacid", "Acetaldehyde_Vinylacetat", "Acetone_Carbontetra", "Acetone_Acetonitrile", "Acetone_Methanol", "Acetone_Aceticacid", "Acetone_Furfural", "Acetone_Nhexane", "Acetone_Water", "Acetone_Vinylacetat", "Methanol_Carbontetra", "Methanol_Ipropanol", "Methanol_Ethylacetat", "Methanol_Diethylamin", "Methanol_Methylisobut", "Methanol_Nhexane", "Methanol_Two.threedimethyl", "Methanol_Triethylamin", "Methanol_Anisole", "Ethanol_One.twodichloro", "Ethanol_Aceticacid", "Ethanol_Npropanol", "Ethanol_Tertbutanol", "Ethanol_Methylcyclop", "Ethanol_Nhexane", "Ethanol_Methylcyclo", "Ethanol_Noctane", "Ethanol_Twotwofourtrimethyl", "Ethanol_Ndecane", "Npropanol_Carbontetra", "Npropanol_Aceticacid", "Npropanol_Benzene", "Npropanol_Nhexane", "Npropanol_Toluene", "Npropanol_Nheptane", "Npropanol_Water", "Ipropanol_Ethylacetat", "Ipropanol_Benzene", "Ipropanol_Nheptane", "Ipropanol_Water", "Ipropanol_Twotwofourtrimethyl", "Nbutanol_Carbontetra", "Nbutanol_Aceticacid", "Nbutanol_Nhexane", "Nbutanol_Nheptane", "Nbutanol_Noctane", "Ibutanol_Benzene", "Secbutanol_Benzene", "Tertbutanol_Benzene", "Formicacid_Aceticacid", "Aceticacid_Toluene", "Aceticacid_Nheptane", "Propionicacid_Methylisobut", "Propionicacid_Noctane", "Methylacetate_Chloroform", "Methylacetate_Benzene", "Ethylacetate_Aceticacid", "Ethylacetate_Npropanol", "Ethylacetate_Furfural", "Ethylacetate_Benzene", "Ethylacetate_Toluene", "Ethylacetate_Ethylbenzen", "Vinylacetate_Aceticacid", "Vinylacetate_Water", "Dioxane_Benzene", "Carbontetrachloride_Acetonitrile", "Carbontetrachloride_Ethanol", "Carbontetrachloride_Furfural", "Carbontetrachloride_Benzene", "Carbontetrachloride_Cyclohexane", "Carbontetrachloride_Methylcyclop", "Carbontetrachloride_Toluene", "Carbontetrachloride_Nheptane", "Dichloromethane_Dichloroetan", "Chloroform_Carbontetra", "Chloroform_Formicacid", "Chloroform_Aceticacid", "Chloroform_Ethylacetate", "Chloroform_Benzene", "Nitromethane_Carbontetra", "Nitromethane_Benzene", "Nitroethane_Carbontetra", "Nitroethane_Npropanol", "Nitroethane_Benzene", "Onenitropropane_Carbontetra", "Onenitropropane_Benzene", "Twonitropropane_Carbontetra", "Twonitropropane_Benzene", "Twonitropropane_Nhexane", "Acetonitrile_Benzene", "Acetonitrile_Nheptane", "Acrylonitrile_Acetonitrile", "Aniline_Methylcyclop", "Furfural_Onebutene", "Furfural_Nbutane", "Furfural_Ibutane", "Furfural_Benzene", "Furfural_Cyclohexane", "Water_Formicacid", "Water_Acetonitrile", "Water_Nitroethane", "Water_Dioxane", "Water_Onebutene", "Water_Ibutane", "Water_Toluene", "Water_Acrylonitril", "Water_Cisbutenetwo", "Water_Transbutene", "Water_Isobutene", "Water_Butadiene", "Carbondisulfide_Methanol", "Carbondisulfide_Acetone"};
  constant Real BI_Values[440, 2] = {{1289.4881, 6.7114}, {938.0838, -112.7209}, {849.013, -56.7699}, {1056.8977, -135.5484}, {743.1034, -127.2476}, {1251.6417, -391.9511}, {1525.5351, -516.0584}, {1403.5125, -70.3003}, {1499.6766, -66.3796}, {983.1208, -123.8651}, {1329.9294, -21.5842}, {970.6914, -128.7022}, {1300.2481, -72.9715}, {1489.1438, -97.747}, {1477.5985, -92.9294}, {1514.3534, -144.3088}, {912.9208, -118.3758}, {1410.4509, -61.3753}, {-119.7224, -29.4499}, {72.2429, 197.453}, {70.7224, -58.3017}, {5.7397, 0.5699}, {378.6125, 20.5261}, {860.8206, -554.8868}, {121.3912, -119.706}, {-1132.16, -231.7521}, {735.9692, 208.343}, {416.3831, -377.9488}, {1263.005, -81.883}, {1566.0069, -781.5877}, {-358.9226, 604.28}, {-468.3882, 27.3851}, {-77.5361, 543.595}, {-315.279, 555.7418}, {94.5536, 117.867}, {-300.8429, 385.863}, {146.0313, 100.2596}, {366.3689, -250.2784}, {-184.485, 559.8999}, {775.153, 30.4806}, {147.6576, -8.2705}, {-337.1298, 549.2958}, {-271.0633, 1304.9835}, {-474.7791, 762.8153}, {-84.2364, 403.8524}, {-67.7213, 1117.8797}, {-32.2887, 1703.2055}, {-58.1103, 1190.6454}, {17.9144, 1360.0217}, {-95.2921, 1463.4548}, {-92.0642, 984.2538}, {101.9628, 334.9587}, {-80.7067, 1094.1304}, {-40.7254, -51.0491}, {-366.7607, 84.4189}, {7.1816, 0.3295}, {-156.3839, 103.9406}, {-26.2861, 113.5565}, {-265.3781, 1099.9741}, {-25.1614, 600.3028}, {-136.0158, 584.0634}, {-153.2518, 629.7314}, {-19.0988, 451.089}, {-138.9829, 770.3047}, {-28.6882, 675.1045}, {40.3898, 121.5049}, {471.807, -279.7321}, {-291.983, 403.6892}, {-286.6527, 490.8909}, {425.4563, -393.3415}, {-98.6602, 843.2593}, {-100.1669, 594.2312}, {-83.8392, 609.2057}, {-383.9791, 153.8253}, {-90.0876, 1245.166}, {-118.0717, 1402.7818}, {-144.7753, 517.8626}, {-603.5633, 950.103}, {-206.2407, 81.4664}, {-78.8509, -53.173}, {-38.5257, 1529.9926}, {-174.2617, 892.9417}, {38.3254, 1391.4917}, {-318.8007, 905.0708}, {-502.2428, 548.3889}, {-272.5909, 272.4921}, {-12.605, 1363.9261}, {1.0023, 1552.7297}, {-27.9877, 1578.6097}, {-57.095, 1259.4286}, {-41.7377, 1208.1529}, {-47.6694, 1231.2086}, {-32.2567, 1396.3019}, {-32.7911, 1561.8955}, {-59.6929, 1577.3145}, {18.9334, 484.2757}, {-149.1808, 952.0283}, {173.801, 109.8687}, {-305.3246, 881.3549}, {94.2417, 98.7523}, {-25.7234, 250.3958}, {-127.9893, 744.8826}, {-153.0128, 1100.3231}, {-97.5633, 698.6183}, {-150.277, 1127.5232}, {-63.9673, 664.259}, {-61.6485, 783.4873}, {392.2083, 91.3933}, {-39.1051, 669.688}, {-25.2901, -86.9343}, {818.093, -200.1567}, {437.5184, -324.6275}, {181.0206, -57.8238}, {-77.9585, 662.4746}, {50.8172, 212.2982}, {177.7675, 306.35}, {-712.473, 1116.7138}, {-311.9029, 474.5511}, {-117.4292, 220.9133}, {378.8209, -378.8991}, {-105.4041, 544.4089}, {-260.5944, 652.4019}, {-13.0186, 405.1733}, {82.3751, -18.3336}, {-169.9204, 998.8196}, {-205.6039, 1032.724}, {1262.584, -446.4834}, {139.4905, -225.4203}, {-578.9542, 942.9023}, {634.1484, -339.732}, {-38.4912, 384.6715}, {-177.4837, 780.0513}, {-305.4069, 674.3341}, {928.9185, -379.9781}, {-432.4206, 583.2958}, {-161.4264, 631.1662}, {-115.7807, 1040.2891}, {-127.6343, 841.5199}, {-152.8323, 1156.688}, {-165.9382, 1120.4853}, {-401.4408, 1783.7857}, {-180.7604, 627.9668}, {190.5947, 290.554}, {-13.5513, 473.6899}, {-729.0848, 1660.0903}, {-83.3064, -4.418}, {-300.7498, 511.0851}, {-274.4208, 15.9476}, {114.789, -169.5098}, {47.0059, -46.6524}, {423.4439, -423.9207}, {-27.435, 256.1456}, {-91.8942, 278.7259}, {-19.2402, 27.9161}, {1.3035, 311.4544}, {163.7157, -281.9383}, {199.1862, -290.3666}, {180.7309, -293.8268}, {-585.5214, 1186.3162}, {-1.1304, 48.1557}, {-218.4928, 677.0367}, {-1.7464, 340.4905}, {-595.2165, 936.7248}, {-91.2018, 743.266}, {-74.7475, 427.6292}, {-48.752, 525.9933}, {-175.9432, 744.763}, {89.4506, 31.0832}, {327.443, 64.4408}, {103.5993, -103.7179}, {350.1707, 309.5428}, {230.5098, 271.3048}, {281.7442, 47.6526}, {623.2636, -2.0107}, {830.7943, 47.5023}, {611.2312, -70.982}, {267.0169, -79.2922}, {1441.5619, -205.7336}, {436.0416, -98.562}, {483.9533, -67.6116}, {1198.9207, 102.271}, {906.3646, -157.3556}, {642.6982, -171.8091}, {1415.2748, 81.2811}, {1024.985, -203.711}, {1098.9416, -44.1418}, {657.2765, -4.6934}, {10542.2026, -344.1682}, {791.0185, -210.2403}, {835.2626, 10.5163}, {559.1539, -260.1951}, {381.8256, -244.669}, {1029.3332, -171.0842}, {957.274, -252.3762}, {7661.2894, -187.7083}, {1516.5558, -229.3734}, {796.2935, -172.0713}, {1295.4282, -271.461}, {981.7658, -335.4504}, {272.4952, 107.634}, {538.1802, -90.5235}, {1260.1312, 81.3308}, {748.22, -172.7007}, {-1070.3252, 1057.3916}, {-520.5358, -200.8021}, {-1071.4286, 1018.5371}, {-71.2521, -231.1124}, {149.3345, -412.065}, {242.4137, 2458.766}, {701.924, -371.1197}, {721.1889, -312.3228}, {-613.4553, 1006.1474}, {426.0894, -302.8076}, {-379.6694, 874.815}, {-17.1391, -220.6087}, {-188.4751, -68.9772}, {-553.685, 1001.0323}, {266.3109, 332.5988}, {367.0686, 510.5582}, {395.4004, 537.1531}, {535.7543, -38.2344}, {-110.3829, 698.7989}, {752.9217, 39.6746}, {934.8834, -501.3763}, {-251.6868, 407.0073}, {-867.7066, 2091.772}, {-292.3021, -523.6271}, {-175.0216, -724.876}, {-417.4722, 1189.9025}, {486.4688, -146.6582}, {-210.5536, 915.1339}, {639.5742, -556.8715}, {-444.013, 1302.0378}, {-397.8616, 997.3999}, {453.4841, -463.0383}, {933.6195, -802.5279}, {548.2453, 89.0444}, {-370.3689, 1635.7568}, {489.1312, -286.7611}, {-346.2827, 900.5916}, {537.7334, -36.221}, {-56.5403, -97.5005}, {-801.2765, 1402.6755}, {819.6231, -223.7898}, {-178.9352, 1021.7979}, {-91.7122, 485.3384}, {-657.2675, 1253.468}, {1280.6209, -655.1387}, {-358.5748, 333.911}, {-334.1695, 857.6208}, {316.6082, 95.0342}, {-56.9399, 1043.7692}, {-286.8493, 1023.7144}, {394.2396, 756.4163}, {-351.0861, 1188.5242}, {-9.7248, 802.6348}, {-172.0599, 1138.3704}, {-178.571, 670.1422}, {83.4921, 304.0167}, {-497.9465, 893.7955}, {-250.5667, 1438.236}, {234.4706, 641.1422}, {-847.2235, 663.5428}, {-310.5637, 1655.4649}, {1653.8373, -379.2679}, {319.3243, -34.2606}, {-0.26, 471}, {-2.01, 604}, {-2.05, 731}, {-1.32, 509}, {-0.38, 473}, {-0.06, 94}, {-0.24, 150}, {264.89, -112.61}, {1, 1}, {266.31, -22.83}, {230.64, -5.86}, {283.76, 34.82}, {-138.84, 162.13}, {34.27, 4.3}, {245.42, -135.93}, {108.24, -72.96}, {333.48, -30.98}, {1107.44, -166.18}, {236.48, 10.66}, {410.08, -4.98}, {80.91, -27.13}, {141.01, -112.66}, {141.11, -94.6}, {1137.2, -201.82}, {1430.77, -259.67}, {1074.76, -207.27}, {15.19, 33.15}, {56.47, -6.47}, {89.77, -48.05}, {517.19, 105.01}, {1284.75, -173.42}, {1393.11, -196.9}, {-32.57, 88.26}, {144.37, -118.82}, {172.73, -145.56}, {83.67, -44.04}, {-76.36, 98.22}, {210.35, -134.19}, {-23.03, 35.11}, {126.71, -98.63}, {-23.03, 35.11}, {350.47, -226.16}, {928.9, -181.24}, {-77.13, 132.43}, {2057.42, 115.13}, {74.87, 244.12}, {3.94, 218}, {3.23, 218}, {1.97, 810}, {2.99, -4}, {2.09, 765}, {-0.05, 1646}, {9.97, -880}, {0.68, 1344}, {-1.67, 814}, {0.07, 336}, {3.76, 913}, {-3.35, 2098}, {0.83, 552}, {0.48, 408}, {-1.04, 1062}, {-3.38, 1878}, {458.43, -212.77}, {-117.74, 243.51}, {-92.32, 246.68}, {-176.38, 261.53}, {359.1, -96.9}, {461.81, -262.3}, {-101.3, 195.63}, {-33.08, 261.51}, {530.99, -100.71}, {-82.48, 110.6}, {-29.64, 1127.95}, {-24.85, 31.22}, {-107.54, 579.61}, {-374.88, 676.42}, {-105.94, 688.03}, {-2.66, 1636.05}, {-7.18, 1463.9}, {-186.66, 664.29}, {-48.39, 782.28}, {-105.66, 929.71}, {-210.53, 244.67}, {210.95, -67.7}, {-2.62, 9.24}, {-118.27, 1383.93}, {-108.93, 1441.57}, {-117.57, 1340.56}, {-109.08, 1385.91}, {-120.42, 1449.61}, {-127.48, 1254.65}, {-166.93, 1336.03}, {299.33, 445.77}, {-155.1, 928.5}, {-144.11, 1326.05}, {-195.4, 818.34}, {-160.43, 1306.22}, {78.37, 583.03}, {-190.57, 522.07}, {-145.52, 854.75}, {-162.54, 1295.6}, {217.23, 11.59}, {-198.06, 994}, {-188.77, 1248.17}, {-296.3, 546.68}, {-159.24, 1370.74}, {-251.11, 1291.98}, {-236.21, 1098.91}, {-162.39, 861.06}, {784.99, -168.83}, {744.89, -165.4}, {-144.58, 241.64}, {-67.91, 298.09}, {-8.49, 342.57}, {-78.49, 136.46}, {-183.2, 556.12}, {-187.87, 121.17}, {203.46, -143.88}, {-214.39, 63.04}, {539.64, -190.31}, {-19.15, 48.52}, {233.81, -181.49}, {309.41, -214.26}, {137.11, -105.5}, {330.03, -124.12}, {1557.23, 131.36}, {363.78, -197.65}, {458.86, -40.18}, {1192.49, -135.27}, {476.85, -100.42}, {-37.52, 43.39}, {98.18, -84.82}, {161.96, -129.21}, {-168.53, 203.67}, {88.3, -59.13}, {1, 1}, {-14.74, 38.19}, {461.38, 90.36}, {346.43, -98.44}, {24.16, -119.49}, {4.98, -50.53}, {0.59, 398.4}, {73.79, 82.2}, {73.06, 295.06}, {574.22, -94.39}, {16.61, 46.05}, {-95.68, 267.13}, {535.16, -246.81}, {-134.32, 307.25}, {794.91, -344.15}, {-32.95, 252.2}, {60.28, 89.57}, {23.71, 545.79}, {183.65, -142.35}, {54.36, 228.71}, {49.12, 242.1}, {88.87, 257.71}, {97.14, 268}, {71, 12}, {41.17, 354.83}, {-508.85, 1019.29}, {122.02, 122.07}, {138.44, 920.08}, {-328.7, 927.26}, {590.17, 777.95}, {646.79, 1173.23}, {305.71, 1371.36}, {155.78, 471.21}, {356.45, -18.31}, {356.45, -18.31}, {346.74, 657.5}, {496.1, 270.6}, {1166.49, 138.15}, {157.31, 103.91}};
algorithm
  for i in 1:NOC loop
    for j in 1:NOC loop
      for k in 1:2 loop
        value[i, j] := 0;
      end for;
    end for;
  end for;
  for i in 1:NOC loop
    for j in 1:NOC loop
      c[i, j] := Comp[i] + underscore + Comp[j];
      d[i, j] := Comp[j] + underscore + Comp[i];
      for k in 1:440 loop
        if c[i, j] == Comp1_Comp2[k] then
          value[i, j] := BI_Values[k, 1];
          value[j, i] := BI_Values[k, 2];
        end if;
        if d[i, j] == Comp1_Comp2[k] then
          value[j, i] := BI_Values[k, 1];
          value[i, j] := BI_Values[k, 2];
        end if;
      end for;
    end for;
  end for;
end BIP_UNIQUAC;
