function [A,B,C,x]=buildMatricesSymbolic(_T)
   ///////////////////////////////////////////////////////////////////////////////
   // Create Matrice A and  vector B corresponding to circuit equation
   global g;
   Nodes=node_number(g);
   A = emptystr(Nodes-1+_T,Nodes-1+_T);
   C = emptystr(Nodes-1+_T,Nodes-1+_T);
   B = emptystr(Nodes-1+_T,1);
   x = emptystr(Nodes-1+_T,1);
   
   _T=1;
   controlledSourceFlag=%F
   for i=1:Nodes-1,
     x(i,1)="v"+ msprintf("%d",i)
   end
   for edge_cnt = 1:edge_number(g),
      if(controlledSourceFlag)
        controlledSourceFlag=%F
        continue
      end
      source=g.edges.tail(edge_cnt)-1;
      sink=g.edges.head(edge_cnt)-1;
      value=g.edges.data.devName(edge_cnt);
      select (g.edges.data.type(edge_cnt))
      case 'R' then   // Resistor
       if(~(source==0)) 
         A(source,source) = A(source,source) + " + "+ value;
       end
       if(~(sink==0)) 
         A(sink,sink) = A(sink,sink) +" + "+ value;
       end
       if(~(sink==0) & ~(source==0))
         A(source,sink) = A(source,sink) +" - "+ value;
         A(sink,source) = A(sink,source) +" - "+ value;
       end

      case 'I' then  // Current source
        if(~(source==0)) 
          B(source) = B(source)+" - "+value;
        end
        if(~(sink==0)) 
          B(sink) =B(sink) +" + "+ value;
        end
       
      case 'V' then // Voltage source
       if(~(source==0))
         A(Nodes-1+_T,source) = "1";
         A(source,Nodes-1+_T) = "1";
       end
       if(~(sink==0))
         A(Nodes-1+_T,sink) = "-1";
         A(sink,Nodes-1+_T) = "-1";
       end  
       B(Nodes-1+_T) = value;
       x(Nodes-1+_T)="i"+ value;
       _T=_T+1; 
       
      case 'C' then // Capacitor
        if(~(source==0)) 
          C(source,source) = C(source,source) +" + "+ value;
        end
        if(~(sink==0)) 
          C(sink,sink) = C(sink,sink) +" + "+ value;
        end
        if(~(sink==0) & ~(source==0))
          C(source,sink) = C(source,sink) +" - "+value;
          C(sink,source) = C(sink,source) +" - "+value;
        end
       
      case 'D' then // Diode
       if(~(source==0)) 
         A(source,source) = A(source,source) +" + "+ value;
       end
       if(~(sink==0)) 
         A(sink,sink) = A(sink,sink) +" + "+ value;
       end
       if(~(sink==0) & ~(source==0))
         A(source,sink) = A(source,sink) +" - "+ value;
         A(sink,source) = A(sink,source) +" - "+ value;
       end
       
      case 'G' then // Voltage controlled current source
       if(~(source==0)) 
         if(~(g.edges.tail(edge_cnt+1)-1==0))
           A(source,g.edges.tail(edge_cnt+1)-1) = A(source,g.edges.tail(edge_cnt+1)-1) +" + "+ value;
         end
         if(~(g.edges.head(edge_cnt+1)-1==0))
            A(source,g.edges.head(edge_cnt+1)-1) = A(source,g.edges.head(edge_cnt+1)-1) +" - "+ value;
         end
       end
       if(~(sink==0)) 
         if(~(g.edges.tail(edge_cnt+1)==1))
            A(sink,g.edges.tail(edge_cnt+1)-1) = A(sink,g.edges.tail(edge_cnt+1)-1) +" - "+ value;
         end
         if(~(g.edges.head(edge_cnt+1)-1==0))
            A(sink,g.edges.head(edge_cnt+1)-1) = A(sink,g.edges.head(edge_cnt+1)-1) +" + "+ value;
         end
       end
       controlledSourceFlag=%T
       
      case 'E' then  // Voltage controlled voltage source
       if(~(source==0))
         A(source,Nodes-1+_T) = "1";
         A(Nodes-1+_T,source) = "1";
        if(~(g.edges.tail(edge_cnt+1)-1==0))
          A(Nodes-1+_T,g.edges.tail(edge_cnt+1)-1) = value;
        end
        if(~(g.edges.head(edge_cnt+1)==1))
          A(Nodes-1+_T,g.edges.head(edge_cnt+1)-1) = "-"+value;
        end
       end
       if(~(sink==0))
          A(sink,Nodes-1+_T) = "-1";
          A(Nodes-1+_T,sink) = "-1";
          if(~(g.edges.tail(edge_cnt+1)-1==0))
            A(Nodes-1+_T,g.edges.tail(edge_cnt+1)-1) = "-"+value;
          end
          if(~(g.edges.head(edge_cnt+1)-1==0))
            A(Nodes-1+_T,g.edges.head(edge_cnt+1)-1) = value;
          end
       end  
       x(Nodes-1+_T)="i"+ value;
       _T=_T+1;
       controlledSourceFlag=%T
        
      case 'F' then  // Current controlled current source
        A(Nodes-1+_T,Nodes-1+_T) = 1;
        A(Nodes-1+_T,Nodes-1+_T-1) = -value;
        if(~(source==0))
          A(source,Nodes-1+_T) = 1;
        end
        if(~(sink==0))
          A(sink,Nodes-1+_T) = -1;
        end  
        x(Nodes-1+_T)="i"+ value;
        _T=_T+1;
         
      case 'H' then // Current controlled voltage source
        A(Nodes-1+_T,Nodes-1+_T-1) = -value;
        if(~(source==0))
          A(source,Nodes-1+_T) = 1;
          A(Nodes-1+_T,source) = 1;
        end
        if(~(sink==0))
          A(sink,Nodes-1+_T) = -1;
          A(Nodes-1+_T,sink) = -1;
        end  
        x(Nodes-1+_T)="i"+ value;
        _T=_T+1;
        
      case 'M' then  // MOSFET
       if(~(source==0)) 
         A(source,source) = A(source,source) + value;
       end
       if(~(sink==0)) 
         A(sink,sink) = A(sink,sink) + value;
       end
       if(~(sink==0) & ~(source==0))
         A(source,sink) = A(source,sink) - value;
         A(sink,source) = A(sink,source) - value;
       end
       
      case 'X' then   // User defined component
       if(~(source==0)) 
         A(source,source) = A(source,source) +" + "+ value;
       end
       if(~(sink==0)) 
         A(sink,sink) = A(sink,sink) +" + "+ value;
       end
       if(~(sink==0) & ~(source==0))
         A(source,sink) = A(source,sink) +" - "+value;
         A(sink,source) = A(sink,source) +" - "+value;
       end
  
     else
        exit(0);
      end
   end
   _T=_T-1;   

// Fill zero entries
   for i=1:Nodes-1+_T,
     if(length(B(i,1))==0)
       B(i,1)="0";
     end
     for j=1:Nodes-1+_T,
       if(length(A(i,j))==0)
         A(i,j)="0";
       end
       if(length(C(i,j))==0)
         C(i,j)="0";
       end
     end
   end
endfunction
