function [A,B,x]=OPAnalysis(A,B)
// Find node potetial and current through devices whose device characteristic can not be expressed in terms of voltage
  x=findNodePotential(A,B);

// Find branch voltage from node potential
  voltage=findBranchVoltage(x);

// Find branch current from branch voltage using device characteristic
  current=findBranchCurrent(x,voltage);

  if(_X)
    for i=1:MaxNRitr
// Check device characteristic of non-linear devices
       flag=checkForDeviceChar(voltage,current);
       if(flag) break; end
// Call Newton Raphson method to update the value of linearized model of nonlinear devices
       [A,B]=NR(A,B,voltage,current,i-1);
       x=findNodePotential(A,B);
       voltage=findBranchVoltage(x);
       current=findBranchCurrent(x,voltage);
    end
  end
endfunction

function x=findNodePotential(A,B)
// START: Solving Ax=B for Node potential x
  A_sparse=sparse(A);   
  x=lusolve(A_sparse,B);
  clear A_sparse;
// END: Solving Ax=B for x
endfunction

function voltage=findBranchVoltage(x)
// Find voltages of complete network 
  global g;
  Edges=edge_number(g);
  voltage=zeros(Edges,1)
  for edge_cnt = 1:Edges,
     if(g.edges.head(edge_cnt)==1)
  	voltage(edge_cnt)=x(g.edges.tail(edge_cnt)-1);
     elseif(g.edges.tail(edge_cnt)==1)
  	voltage(edge_cnt)=-x(g.edges.head(edge_cnt)-1);
     else 
  	voltage(edge_cnt)=x(g.edges.tail(edge_cnt)-1)-x(g.edges.head(edge_cnt)-1);
     end     
  end
endfunction

function current=findBranchCurrent(x,voltage)
  global g;
  T=1;
  Nodes=node_number(g);
  Edges=edge_number(g);
  current=zeros(Edges,1)
  for edge_cnt = 1:Edges,
     if(g.edges.data.type(edge_cnt)=='R'|g.edges.data.type(edge_cnt)=='D'|g.edges.data.type(edge_cnt)=='X'|g.edges.data.type(edge_cnt)=='M')
  	current(edge_cnt)=g.edges.data.value(edge_cnt)*voltage(edge_cnt);
     elseif(g.edges.data.type(edge_cnt)=='V')
  	current(edge_cnt)=x(Nodes-1+T);
  	T=T+1;
     elseif(g.edges.data.type(edge_cnt)=='E')
  	current(edge_cnt)=x(Nodes-1+T);
  	T=T+1;
     elseif(g.edges.data.type(edge_cnt)=='F')
  	current(edge_cnt)=x(Nodes-1+T);
  	T=T+1;
     elseif(g.edges.data.type(edge_cnt)=='H')
  	current(edge_cnt)=x(Nodes-1+T);
  	T=T+1;
     elseif(g.edges.data.type(edge_cnt)=='G')
  	current(edge_cnt)=voltage(edge_cnt+1)*g.edges.data.value(edge_cnt);
     else      
  	current(edge_cnt)=g.edges.data.value(edge_cnt);
     end
  end
endfunction
