function [A,B,x]=ACAnalysis(A,B,_X,f)
// Modify Sweep Source Value and update matrices
  [C,d]=buildMatricesAC(A,B,f);

// Find node potetial and current through devices whose device characteristic can not be expressed in terms of voltage
  x=findNodePotential(C,d); 

// Find branch voltage from node potential
  voltage=findBranchVoltage(x);

// Find branch current from branch voltage using device characteristic
  current=findBranchCurrent(x,voltage);
endfunction

function [C,d]=buildMatricesAC(A,B,f); 
  global g;
  pi=3.14;
  _C=1;
  Edges=edge_number(g);
  Nodes=node_number(g);
  [rows cols]=size(A);
  A2 = zeros(rows,cols);
  b2 = zeros(cols,1);
  for edge_cnt = 1:Edges,
    if(g.edges.data.type(edge_cnt)=='C')
      source=g.edges.tail(edge_cnt)-1;
      sink=g.edges.head(edge_cnt)-1;
      if(~(source==0)) 
        A2(source,source) = A2(source,source)+2*pi*f*cValue(_C);
      end
      if(~(sink==0)) 
        A2(sink,sink) = A2(sink,sink)+2*pi*f*cValue(_C);
      end
      if(~(sink==0) & ~(source==0))
        A2(source,sink) = A2(source,sink)-2*pi*f*cValue(_C);
        A2(sink,source) = A2(sink,source)-2*pi*f*cValue(_C);
      end
      _C=_C+1;  
    end
  end
  C=[A -A2;A2 A];
  d=[B;b2];
endfunction

function buildDCOutput(x,s,itr)
  global vPrintList; 
  global iPrintList; 
  global sweepArray;
  global vPrintArray; 
  global iPrintArray;
  sweepArray(itr)=s;
// Store voltage output for printing  
  if(~(vPrintList(1)==0))
    fill_vPrintArray(x,itr);
    vPrintArray(itr,1)=s;
  end

// Store voltage output for plotting  
  if(~(vPlotList(1)==0))
    fill_vPlotArray(x,itr);
  end

// Store current output for printing  
  if(~(iPrintList(1)==0))
    fill_iPrintArray(x,itr);
    iPrintArray(itr,1)=s;
  end

// Store current output for plotting  
  if(~(iPlotList(1)==0))
    fill_iPlotArray(x,itr);
  end
endfunction
